// Service worker for elead to OttoReply extension

// Pattern to match elead customer/deal pages
const ELEAD_DEAL_PATTERN = /eleadcrm\.com.*OpptyDetails\.aspx/i;

// Listen for tab updates to detect elead pages
chrome.tabs.onUpdated.addListener((tabId, changeInfo, tab) => {
  if (changeInfo.status === 'complete' && tab.url) {
    updateBadgeForTab(tabId, tab.url);
  }
});

// Listen for tab activation to update badge
chrome.tabs.onActivated.addListener(async (activeInfo) => {
  try {
    const tab = await chrome.tabs.get(activeInfo.tabId);
    if (tab.url) {
      updateBadgeForTab(activeInfo.tabId, tab.url);
    }
  } catch (error) {
    // Tab might not exist anymore
    console.log('Could not get tab:', error);
  }
});

// Update badge based on whether we're on an elead deal page
function updateBadgeForTab(tabId, url) {
  if (isEleadDealPage(url)) {
    // Show indicator that we can link this deal
    chrome.action.setBadgeText({ tabId, text: '!' });
    chrome.action.setBadgeBackgroundColor({ tabId, color: '#4CAF50' });
  } else {
    // Clear badge
    chrome.action.setBadgeText({ tabId, text: '' });
  }
}

// Check if URL is an elead deal/customer page
function isEleadDealPage(url) {
  return ELEAD_DEAL_PATTERN.test(url);
}
